/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.impl2.VWSIMAnimationDP;
import filenet.sim.api.Enum;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMDocumentRefreshException;
import filenet.sim.api.VWSIMNoProcessSimulatorException;
import filenet.sim.api.VWSIMSimulationVerifyException;
import filenet.sim.api.VWSIMXMLOptions;
import filenet.sim.api.VWScenarioConfiguration;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.appserver.IVWSIMCommand;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.io.ByteArrayInputStream;
import java.util.GregorianCalendar;
import simulator.util.VWSIMException;

public class VWSIMSimulation
implements IVWSIMSimulation {
    private static Logger logger = Logger.getLogger("filenet.sim.api");
    private static final String m_className = "VWSIMSimulation";
    private String m_creator = null;
    private String m_system = null;
    private int m_region = 0;
    private IVWIDMDocument m_idmDocument = null;
    private VWScenarioDefinition m_scenarionDef = null;
    private boolean m_publishingEnabled = false;
    private String m_guid = null;
    private boolean m_invalid = false;
    protected IVWSIMCommand vwsimCommandInterface = null;
    private IVWSIMAnimationDP m_animationDP = null;
    private String[] m_files = null;
    private boolean m_completed = false;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:46:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.51  $";
    }

    public VWSIMSimulation(String system, int region, String simulationName, IVWIDMDocument idmDocument, IVWSIMCommand vwsimCommandInterface) throws VWException {
        this.m_system = system;
        this.m_region = region;
        this.m_idmDocument = idmDocument;
        this.vwsimCommandInterface = vwsimCommandInterface;
    }

    public VWSIMSimulation(IVWIDMDocument idmDocument, IVWSIMCommand vwsimCommandInterface) throws VWException {
        this.m_idmDocument = idmDocument;
        this.vwsimCommandInterface = vwsimCommandInterface;
        this.m_guid = (String)idmDocument.getProp("SimulationGUID");
    }

    public String getName() throws VWException {
        return this.m_idmDocument.getLabel();
    }

    public void setName(String name) throws VWException {
        this.m_idmDocument.setProp("DocumentTitle", name);
    }

    public String getDescription() throws VWException {
        return (String)this.m_idmDocument.getProp("SimulationDescription");
    }

    public void setDescription(String description) throws VWException {
        this.m_idmDocument.setProp("SimulationDescription", description);
    }

    public boolean getCollectAnalysisData() throws VWException {
        Boolean publishingEnabled = (Boolean)this.m_idmDocument.getProp("PublishingEnabled");
        if (publishingEnabled != null) {
            return publishingEnabled;
        }
        return false;
    }

    public VWScenarioDefinition getScenariodefinition() throws VWException {
        if (this.m_scenarionDef != null) {
            return this.m_scenarionDef;
        }
        VWScenarioDefinition sceDef = null;
        byte[] contents = null;
        contents = this.m_idmDocument.getContents();
        ByteArrayInputStream is = null;
        if (contents != null) {
            is = new ByteArrayInputStream(contents);
        }
        sceDef = VWScenarioDefinition.read(is);
        this.m_scenarionDef = sceDef;
        return sceDef;
    }

    public String getSimulationDocId() {
        return this.m_idmDocument.getId();
    }

    public String getLibraryId() {
        return this.m_idmDocument.getLibraryId();
    }

    public String getId() throws VWException {
        return (String)this.m_idmDocument.getProp("SimulationGUID");
    }

    public boolean canStart() throws VWException {
        boolean canStart = false;
        int i = this.getStatus();
        if (i != 0) {
            return canStart;
        }
        return this.m_idmDocument.canCheckout();
    }

    public boolean canStop() throws VWException {
        boolean canStop = false;
        this.m_idmDocument.refresh();
        int i = this.getStatus();
        if (i != 1) {
            return canStop;
        }
        return this.m_idmDocument.canCheckout();
    }

    private String formulateSimUrl(String origUrl) {
        String m_method = "formulateSimUrl:" + origUrl;
        try {
            String s = (String)VWIDMBaseFactory.instance().getProperties().getProperty("nonSSO.listener.base.url");
            if (s != null) {
                origUrl = s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, origUrl);
        }
        return origUrl;
    }

    public void start() throws VWException {
        if (!this.canStart()) {
            throw new VWException("sim.api.VWSIMSimulation.startNotAllowed", "Can not start this simulation. Please make sure you have the privilege to start the simulation.");
        }
        try {
            StringBuffer bufferSce;
            VWScenarioConfiguration confg;
            VWScenarioDefinition scedef;
            Object contents = null;
            String sScnXML = null;
            if (this.m_system == null) {
                scedef = this.getScenariodefinition();
                confg = scedef.getConfiguration();
                this.m_system = confg.getServiceName();
                this.m_region = confg.getIsolatedRegion();
                bufferSce = new StringBuffer();
                scedef.toXML(bufferSce);
                if (logger.isFinest()) {
                    logger.finest(m_className, "start simulation with xml: ", bufferSce.toString());
                }
                sScnXML = bufferSce.toString();
            } else {
                scedef = this.getScenariodefinition();
                confg = scedef.getConfiguration();
                bufferSce = new StringBuffer();
                scedef.toXML(bufferSce);
                if (logger.isFinest()) {
                    logger.finest(m_className, "start simulation with the following xml: ", bufferSce.toString());
                }
                sScnXML = bufferSce.toString();
            }
            Integer lifeSpan = null;
            int simLifeSpan = 2;
            lifeSpan = (Integer)this.m_idmDocument.getProp("SimulationLifeSpanInHours");
            if (lifeSpan != null) {
                simLifeSpan = lifeSpan;
            }
            String simUrl = this.formulateSimUrl(this.vwsimCommandInterface.getUrl());
            VWSIMXMLOptions op = new VWSIMXMLOptions(this.m_idmDocument.getLibraryId(), this.m_idmDocument.getCanonicalName(), this.m_system, this.m_region, this.getName(), simLifeSpan, VWIDMBaseFactory.getWebApp(), simUrl);
            Object optionsXML = null;
            StringBuffer bufferOptions = new StringBuffer();
            op.toXML(bufferOptions);
            this.m_guid = this.vwsimCommandInterface.startSimulation(sScnXML, bufferOptions.toString());
            this.m_idmDocument.setProp("SimulationGUID", this.m_guid);
            this.m_idmDocument.save();
        }
        catch (VWSIMException e) {
            logger.severe(m_className, "start", e.getCauseClassName() + ": msg=" + e.getCauseDescription());
            throw e;
        }
        catch (VWException e) {
            logger.throwing(m_className, "start", e);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.throwing(m_className, "start", e);
            throw new VWException("sim.api.VWSIMSimulation.StartError", "start simulation fail. {0}", e.getLocalizedMessage());
        }
    }

    public void stop() throws VWException {
        if (!this.canStop()) {
            if (this.getStatus() == 4) {
                throw new VWException("sim.api.VWSIMSimulation.SimulationAlreadyCompleted", "The simulation has already completed. Could not stop the simulation");
            }
            throw new VWException("sim.api.VWSIMSimulation.stopNotAllowed", "Cannot stop this simulation. Please refresh to see its status.");
        }
        try {
            this.vwsimCommandInterface.stopSimulation(this.m_guid);
        }
        catch (VWSIMException e) {
            logger.severe(m_className, "stop", e.getCauseClassName() + ": msg=" + e.getCauseDescription());
            throw e;
        }
        catch (VWException e) {
            logger.throwing(m_className, "stop", e);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VWException("sim.api.VWSIMSimulation.StopError", "Stop simulation fail. {0} ", e.getMessage());
        }
    }

    public int getStatus() throws VWException {
        int status = 0;
        String statusString = (String)this.m_idmDocument.getProp("SimulationStatus");
        if (statusString != null) {
            if (statusString.startsWith("-1")) {
                return -1;
            }
            if (statusString.startsWith("0")) {
                return 0;
            }
            if (statusString.startsWith("1")) {
                return 1;
            }
            if (statusString.startsWith("3")) {
                return 3;
            }
            if (statusString.startsWith("4")) {
                return 4;
            }
        } else {
            return 0;
        }
        return status;
    }

    public void deleteSimulation() throws VWException {
        this.m_idmDocument.delete();
    }

    public String getScenarioDefinitionDocId() throws VWException {
        return (String)this.m_idmDocument.getProp("ScenarioDefinitionDocId");
    }

    public IVWIDMDocument getIDMDocument() {
        return this.m_idmDocument;
    }

    public void startPublish() throws VWException {
        try {
            this.vwsimCommandInterface.startPublish(this.m_guid);
        }
        catch (VWSIMException e) {
            throw e;
        }
        catch (VWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWSIMSimulation.FailToStartPublishing", "Fail to start publishing. {0}", e.getMessage());
        }
    }

    public void stopPublish() throws VWException {
        try {
            this.vwsimCommandInterface.stopPublish(this.m_guid);
        }
        catch (VWSIMException e) {
            throw e;
        }
        catch (VWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWSIMSimulation.FailToStopPublishing", "Fail to stop publishing. {0}", e.getMessage());
        }
    }

    public IVWSIMAnimationDP getAnimationDataProvider() throws VWException {
        if (this.m_invalid) {
            throw new VWException("sim.api.VWSIMSimulation.SimulationNotExist", "The simulation does not exist.");
        }
        try {
            this.m_idmDocument.refresh();
        }
        catch (VWSIMDocumentRefreshException e) {
            this.m_invalid = true;
            throw new VWSIMDocumentRefreshException();
        }
        try {
            this.verify();
        }
        catch (VWSIMSimulationVerifyException e) {
            this.m_invalid = true;
            throw e;
        }
        if (this.m_animationDP == null) {
            if (this.m_guid == null) {
                this.m_guid = (String)this.m_idmDocument.getProp("SimulationGUID");
            }
            if (this.m_guid == null) {
                throw new VWException("sim.api.VWSIMSimulation.SimulationNotStarted", "The simulation has not been started yet: {0}", this.getName());
            }
            this.m_animationDP = new VWSIMAnimationDP(this.vwsimCommandInterface, this);
        }
        return this.m_animationDP;
    }

    public String getSimulationFailureMessage() throws VWException {
        String message = null;
        String status = (String)this.m_idmDocument.getProp("SimulationStatus");
        if (status != null && status.startsWith("-1")) {
            message = status.substring(2);
        }
        return message;
    }

    public void refresh() throws VWException {
        try {
            this.m_idmDocument.refresh();
        }
        catch (Exception e) {
            throw new VWSIMDocumentRefreshException(e.getMessage());
        }
    }

    public GregorianCalendar getDateCreated() throws VWException {
        return (GregorianCalendar)this.m_idmDocument.getProp("DateCreated");
    }

    public boolean verify() throws VWException {
        String m_method = "verify";
        boolean valid = false;
        try {
            if (!this.isCompleted()) {
                this.vwsimCommandInterface.getStatus(this.m_guid);
            } else {
                int nFiles;
                String[] files = this.getContentElementsToFile();
                int n = nFiles = files == null ? 0 : files.length;
                if (nFiles < 3) {
                    logger.severe(m_className, "verify", "Sim doc " + this.m_guid + " does not have the required contents!");
                    throw new VWSIMNoProcessSimulatorException();
                }
            }
            valid = true;
        }
        catch (VWSIMNoProcessSimulatorException e) {
            logger.info(m_className, "verify", "This simulation does not exist on Process Simulator");
            throw e;
        }
        catch (VWSIMException e) {
            logger.severe(m_className, "verify", e.getCauseClassName() + ": msg=" + e.getCauseDescription());
            throw e;
        }
        catch (Exception e) {
            logger.info(m_className, "verify", "Exception when try to verify this simulation on Process Simulator");
            throw new VWSIMSimulationVerifyException(e.getLocalizedMessage() + ", name = " + this.getName());
        }
        return valid;
    }

    public GregorianCalendar getDateLastModified() throws VWException {
        return (GregorianCalendar)this.m_idmDocument.getProp("DateLastModified");
    }

    public String getCreator() throws VWException {
        if (this.m_creator != null) {
            return this.m_creator;
        }
        this.m_creator = (String)this.m_idmDocument.getProp("Creator");
        return this.m_creator;
    }

    public boolean isCompleted() throws VWException {
        if (!this.m_completed) {
            this.m_completed = this.getStatus() == 4;
        }
        return this.m_completed;
    }

    public String[] getContentElementsToFile() throws VWException {
        if (this.m_files != null) {
            return this.m_files;
        }
        this.refresh();
        int status = this.getStatus();
        String[] files = this.m_idmDocument.getContentElementsToFile();
        if (status == 4) {
            this.m_files = files;
        }
        return files;
    }

    public String getSimulationGuid() throws VWException {
        return this.m_guid;
    }

    public byte[] getScenarioXML() throws VWException {
        return this.m_idmDocument.getContents();
    }

    public static class Status
    extends Enum {
        public static final Status ERROR = new Status("Error", -1);
        public static final Status INIT = new Status("Init", 0);
        public static final Status STOPPED = new Status("Stopped", 3);
        public static final Status RUNNING = new Status("Running", 1);
        public static final Status COMPLETED = new Status("Completed", 4);

        private Status(String sName, int nOrdinal) {
            super(sName, nOrdinal);
        }
    }
}

